
#property indicator_chart_window

extern int   Window            = 0;
extern int   Corner            = 2;
extern int   Xposition        = 0;
extern int   Yposition        = -8;
extern color BackGroundColor   = White;
extern bool  SortedDisplay     = true;

color    PanelColor1     = clrSilver;
color    PanelColor2     = clrBlack;

string buffername = "CP";
int Fontsize = 12;

#define MajorsNumber 8

int chartpair[2];
string buffer;
string Majors[]  = {"USD","EUR","GBP","JPY","CHF","CAD","NZD","AUD"};            
string Symbols[] = {"EURUSD","GBPUSD","USDJPY","USDCHF","USDCAD","AUDUSD","NZDUSD",
                    "EURGBP","EURJPY","EURCHF","EURCAD","EURAUD","EURNZD",
                    "GBPJPY","GBPCHF","GBPCAD","GBPAUD","GBPNZD",
                    "AUDJPY","AUDCHF","AUDCAD","AUDNZD",
                    "CHFJPY","CADJPY","NZDJPY",
                    "USDSGD"};
string space = "";
string NomeIndi;
int Xoffset[4]={135,150,135,132};  
int Translate(string symbol)
   {
   for(int i=0;i<MajorsNumber;i++)     if(Majors[i] == symbol)   break;  
   return(i);
   }   
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   NomeIndi = WindowExpertName();
   string currency=StringSubstr(Symbol(),0,3);
   chartpair[0]=Translate(currency);
   currency=StringSubstr(Symbol(),3,3);
   chartpair[1]=Translate(currency);
   Show_Panel();
   Yposition+=2;
   
  return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
  for (int i = 0; i <= ArraySize(Majors)*2; i++) 
      {    
       ObjectDelete(Majors[i]+"_val");
       ObjectDelete(Majors[i]+"_nom");
       ObjectDelete(Majors[i]+"_pos");
       }    
       ObjectDelete("AA-Panel-1");
       ObjectDelete("AA-Panel-2");
       ObjectDelete("AA-Panel-3");
       ObjectDelete("AA-Panel-4");
       ObjectDelete("AAObj11d");
       DeleteExistingLabels();
  
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+

void  Show_Panel()
{
      string text="gg";
      int xoffset=130,fontsize=80;
      CreateXX2_Labels( "AA-Panel-1",Xposition+Xoffset[Corner]-xoffset+0,Yposition+35, text, fontsize, "Webdings", PanelColor1);
      CreateXX2_Labels( "AA-Panel-2",Xposition+Xoffset[Corner]-xoffset+0,Yposition+14, text, fontsize, "Webdings", PanelColor1); 
      CreateXX2_Labels( "AA-Panel-3",Xposition+Xoffset[Corner]-xoffset+2,Yposition+35, text, fontsize-2, "Webdings", PanelColor2); 
      CreateXX2_Labels( "AA-Panel-4",Xposition+Xoffset[Corner]-xoffset+2,Yposition+16, text, fontsize-2, "Webdings", PanelColor2); 
       
}
int start()
  {
   int    counted_bars=IndicatorCounted();
  
   displayMeter();
 
   return(0);
  }
  
//+------------------------------------------------------------------+
//| displayMeter function                                            |
//+------------------------------------------------------------------+
void displayMeter() 
   {
   double ValoreZero[MajorsNumber,2];
   color  ColoreZero[MajorsNumber,2];
   
   for(int currency=0; currency<MajorsNumber; currency++)
      {
      ValoreZero[currency,0] = currency_strength(Majors[currency]);
      ValoreZero[currency,1] = currency;
      }

   if(SortedDisplay)
      {
      int mode=MODE_DESCEND;
      if(Corner > 1)   mode=MODE_ASCEND;
      ArraySort(ValoreZero,WHOLE_ARRAY,0,mode);
      }
      
   int win = WindowFind(NomeIndi);
   double value;
   int j,Y2=Yposition+14;
   string Font,Name;
   for(int i=0; i<MajorsNumber; i++)
   {
      j = ValoreZero[i,1];
      color Color=SpringGreen;
      Font="Courier New";
      value=ValoreZero[i,0]*10.0;
      buffer=buffername + Majors[j];
      switch(Corner)
         {
         case 0: Name=(i+1)+" "+Majors[j]; break;
         case 1: Name=(i+1)+" "+Majors[j]; break;
         case 2: Name=(8-i)+" "+Majors[j]; break;
         case 3: Name=(8-i)+" "+Majors[j]; break;
         }
      if(j == chartpair[0] || j == chartpair[1]) {Font="Courier New Bold"; Color=White;}
      if(Corner==0 || Corner==2)   {int nomoffset=-124,  valoffset=47;  }         
      else                         {    nomoffset=26;    valoffset=-124;}
      objectCreate(buffer+"_nom", Corner, Xposition+Xoffset[Corner]+nomoffset, Y2, 0, Name, Fontsize, Font, Color);
      objectCreate(buffer+"_val", Corner, Xposition+Xoffset[Corner]+valoffset, Y2, 0, DoubleToStr(value,0)+"%", Fontsize, Font, Color);
      paintCurr(i,value,Xposition+Xoffset[Corner]-150,Y2+6);
      Y2 += 15;
   }  
}
void paintCurr(int key,double value,int Xpos,int Ypos) 
{ 
   initGraph(key,Xpos,Ypos);
    
   if (value >  0.0) ObjectSet(buffer + "10", OBJPROP_COLOR, C'55,90,80');
   if (value > 10.0) ObjectSet(buffer + "9",  OBJPROP_COLOR, C'65,100,100');
   if (value > 20.0) ObjectSet(buffer + "8",  OBJPROP_COLOR, C'80,120,120');
   if (value > 30.0) ObjectSet(buffer + "7",  OBJPROP_COLOR, C'95,140,140');
   if (value > 40.0) ObjectSet(buffer + "6",  OBJPROP_COLOR, C'110,160,160');
   if (value > 50.0) ObjectSet(buffer + "5",  OBJPROP_COLOR, C'125,180,180');
   if (value > 60.0) ObjectSet(buffer + "4",  OBJPROP_COLOR, C'140,200,200');
   if (value > 70.0) ObjectSet(buffer + "3",  OBJPROP_COLOR, C'155,220,220');
   if (value > 80.0) ObjectSet(buffer + "2",  OBJPROP_COLOR, C'170,240,240');
   if (value > 90.0) ObjectSet(buffer + "1",  OBJPROP_COLOR, C'185,255,255');
  
}
void initGraph(int key, int Xpos, int Ypos) {
   int i,ri, k=50;
   buffer=buffername + "Bar "+key+ "_";
   for(i=1;i<11;i++)
      {
      k=k+11;
      ri=i;
      if(Corner==0 || Corner==2)    ri=11-i;  
      ObjectDelete(buffer+ri);   
      objectCreatea(buffer + ri ,Xpos+k,Ypos);
      }
}
//+------------------------------------------------------------------+
//| currency_strength function                                       |
//+------------------------------------------------------------------+
double currency_strength(string couple) {
   int index;
   string Pair;
   double HiLo;
   double ld_28;
   double ld_ret_36 = 0;
   int cnt = 0;
   for (int i = 0; i < ArraySize(Symbols); i++) {
      index = 0;
      Pair = Symbols[i];
      if (couple == StringSubstr(Pair, 0, 3) || couple == StringSubstr(Pair, 3, 3)) {
         Pair = Pair + space;
         HiLo = (MarketInfo(Pair, MODE_HIGH) - MarketInfo(Pair, MODE_LOW)) * MarketInfo(Pair, MODE_POINT);
         if (HiLo != 0.0) {
            ld_28 = 100.0 * ((MarketInfo(Pair, MODE_BID) - MarketInfo(Pair, MODE_LOW)) / HiLo * MarketInfo(Pair, MODE_POINT));
            if (ld_28 >  3.0) index = 1;
            if (ld_28 > 10.0) index = 2;
            if (ld_28 > 25.0) index = 3;
            if (ld_28 > 40.0) index = 4;
            if (ld_28 > 50.0) index = 5;
            if (ld_28 > 60.0) index = 6;
            if (ld_28 > 75.0) index = 7;
            if (ld_28 > 90.0) index = 8;
            if (ld_28 > 97.0) index = 9;
            cnt++;
            if (couple == StringSubstr(Pair, 3, 3)) index = 9 - index;
            ld_ret_36 += index;
         }
      }
   }
   ld_ret_36 /= cnt;
   return (ld_ret_36);
}

//+------------------------------------------------------------------+
//| objectCreate function                                            |
//+------------------------------------------------------------------+
void objectCreate(string nome, int angolo, int val_x, int val_y, int val_ang, string testo = "-", int fontsize = 42, string fontname = "Arial", color color1 = -1)
   {
   if (ObjectFind(nome) != 0)       ObjectCreate(nome, OBJ_LABEL, Window, 0, 0);
   
   ObjectSet(nome, OBJPROP_CORNER, Corner);
   ObjectSet(nome, OBJPROP_COLOR, color1);
   ObjectSet(nome, OBJPROP_BACK, 0);
   ObjectSet(nome, OBJPROP_XDISTANCE, val_x);
   ObjectSet(nome, OBJPROP_YDISTANCE, val_y);
   ObjectSet(nome, OBJPROP_ANGLE, val_ang);
   ObjectSetText(nome, testo, fontsize, fontname, color1);
   }
   
int CreateXX2_Labels( string bj, int xj, int yj, string text, int fontsize, string font, color colore ) 
   {
   ObjectCreate( bj, OBJ_LABEL, Window, 0, 0 );
   ObjectSet( bj, OBJPROP_CORNER, Corner );
   ObjectSet( bj, OBJPROP_XDISTANCE,xj);
   ObjectSet( bj, OBJPROP_YDISTANCE,yj+(Fontsize/fontsize));
   ObjectSet( bj, OBJPROP_BACK, 0 );
   ObjectSetText(bj, text, fontsize, font, colore);
   return(0);
   }

void objectCreatea(string a_name_0, int Xpos, int Ypos, string a_text_16 = "g", int a_fontsize_24 = 8, string a_fontname_28 = "Webdings", color Color = C'15,50,25' ) {
   ObjectCreate(a_name_0, OBJ_LABEL, Window, 0, 0);
   ObjectSet(a_name_0, OBJPROP_CORNER, Corner);
   int xoffset=0;  if(Corner==0 || Corner==2)   xoffset=21;
   ObjectSet(a_name_0, OBJPROP_XDISTANCE, Xpos + xoffset);
   ObjectSet(a_name_0, OBJPROP_YDISTANCE, Ypos -4);
   ObjectSetText(a_name_0, a_text_16, a_fontsize_24, a_fontname_28, Color);
}

void DeleteExistingLabels() {
   string l_name_4;
   int l_objs_total_0 = ObjectsTotal(OBJ_LABEL);
   if (l_objs_total_0 > 0) {
      for (int l_objs_total_12 = l_objs_total_0; l_objs_total_12 >= 0; l_objs_total_12--) {
         l_name_4 = ObjectName(l_objs_total_12);
         if (StringFind(l_name_4, buffername, 0) >= 0) ObjectDelete(l_name_4);
      }
   }
}


